from parallels.core.dump.data_model import DatabaseServer
from parallels.plesk.source.legacy.migrator import PmmUnixMigrator
from parallels.plesk.source.ppcpl.connections import PPCPLMigratorConnections
from parallels.plesk.source.ppcpl.global_context import PPCPLGlobalMigrationContext
from parallels.plesk.source.ppcpl.web_files import PPCPLWebFiles
from parallels.plesk.source.ppcpl.content.mail import PpcplCopyMailContent


class Migrator(PmmUnixMigrator):
    def _load_connections_configuration(self, global_context, target_panel_type):
        return PPCPLMigratorConnections(global_context, self._get_target_panel_by_name(target_panel_type))

    def _create_global_context(self):
        return PPCPLGlobalMigrationContext()

    @property
    def web_files(self):
        """Object to list files to be transferred from source to target

        :rtype: parallels.core.utils.paths.web_files.BaseWebFiles
        """
        return PPCPLWebFiles()

    # ======================== databases =====================================

    def _get_src_db_server(self, database_server_host, database_server_port, database_server_type, server_dump):
        return DatabaseServer(
            host='localhost',
            port='3306',
            login='root',
            password=self.global_context.dump_agent.get_mysql_admin_password(),
            dbtype='mysql',
            is_default=True,
        )

    def copy_mail_content_single_subscription(self, subscription, issues):
        copy_mail = PpcplCopyMailContent(self.global_context.dump_agent)
        return copy_mail.copy_mail(self.global_context, subscription, issues)