import posixpath

from parallels.core.utils.common_constants import UNIX_SOURCE_DEFAULT_SESSION_DIR
from parallels.core.utils.config_utils import ConfigSection
from parallels.core.migrator_config import read_ssh_auth, SourceUnixServerConfig
from parallels.core.migrator_config import read_copy_mail_content_settings

# This is the ID used for naming config file sections and migration dump files
PANEL_ID = 'ppcpl'


class PPCPLConfig(SourceUnixServerConfig):
    def __init__(self, config_section):
        """Class constructor

        :type config_section: parallels.core.utils.config_utils.ConfigSection
        """
        ip = config_section['ip']
        ssh_auth = read_ssh_auth(config_section)
        session_dir = config_section.get('session-dir', UNIX_SOURCE_DEFAULT_SESSION_DIR)
        mail_settings = read_copy_mail_content_settings(
            config_section, is_windows=False
        )

        SourceUnixServerConfig.__init__(
            self, config_section, PANEL_ID, ip, session_dir, ssh_auth, mail_settings
        )

        self.agent_home = posixpath.join(self.session_dir, 'migration_agent')
        self.pmm_agent_name = "PPCPL"
        self.agent_script_name = 'PPCPL.pl'


def init(config):
    ppcpl_section = ConfigSection(config, PANEL_ID)
    return PPCPLConfig(ppcpl_section)

