# coding=utf-8
from parallels.core.utils.message_utils import single_line_message, multi_line_message

ACTION_VALIDATE_HOSTING_DESCRIPTION_DESCRIPTION = single_line_message("""
    Validate hosting description file
""")
ACTION_VALIDATE_HOSTING_DESCRIPTION_FAILED = single_line_message("""
    Failed to validate hosting description file
""")
ACTION_VALIDATE_HOSTING_DESCRIPTION_NOT_SPECIFIED = single_line_message("""
    Hosting description file is not specified in migration configuration file
""")

ACTION_COPY_WEB_CONTENT_VIA_FTP = single_line_message("""
    Copy files of website using given FTP access
""")
ACTION_COPY_WEB_CONTENT_VIA_FTP_FAILED = single_line_message("""
    Unable to copy files of website '{source}' using given FTP access
""")
ACTION_COPY_WEB_CONTENT_VIA_FTP_UNSUPPORTED_SOURCE_WEB_PATH_TYPE = single_line_message("""
    Unsupported source web path type
""")

ACTION_COPY_DATABASE_CONTENT = single_line_message("""
    Copy databases
""")
ACTION_COPY_DATABASE_CONTENT_FAILED = single_line_message("""
    Failed to copy database content of subscription. Most probably that happens because of a network-related issue.
    Please check network connections between source and target servers, then re-copy database content with the help
    of 'copy-db-content' command
""")
ACTION_COPY_DATABASE_CONTENT_FAILED_DUMP = single_line_message("""
    Database '{database_name}' will not be restored because unable to dump it from source
""")
ACTION_COPY_DATABASE_CONTENT_FAILED_NO_DB_SERVER = single_line_message("""
    Database '{database_name}' will not be restored because there are no {database_type} DB server
    assigned to subscription
""")

ACTION_FIX_PERMISSIONS = single_line_message("""
    Fix permissions for web files
""")
ACTION_FIX_PERMISSIONS_FAILED = single_line_message("""
    Failed to fix permissions for files of subscription '{subscription}'
""")

VALIDATION_FAILED_MIGRATION_STOPPED = multi_line_message("""
    Hosting description file '{file}' validation failed:
    {errors}

    Migration will be stopped. To continue migration fix the errors listed above.
    For details on hosting description format refer to the official migration tool's documentation.

    If you are sure that these errors won't affect migration, you could try
    to specify 'validation-mode: warn' or 'validation-mode: skip' in corresponding source section of migrator's
    configuration file to ignore these errors and force migrator to proceed.
""")
VALIDATION_FAILED = multi_line_message("""
    Hosting description file '{file}' validation failed:
    {errors}
""")
VALIDATION_PASSED = multi_line_message("""
    Hosting description file '{file}' successfully passed validation
""")
