# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package EncodeBase64;

my @cb64 = ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
			'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
			'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
			'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
			'g', 'h', 'i', 'j',	'k', 'l', 'm', 'n',
			'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
			'w', 'x', 'y', 'z', '0', '1', '2', '3',
			'4', '5', '6', '7', '8', '9', '+', '/');

@cb64 = map { ord } @cb64;

sub encodeBlock {
  my ($len, @in) = @_;
  my @res;
  push @res, $cb64[$in[0] >> 2];
  push @res, $cb64[(($in[0] & 0x3)<<4)|(($in[1]&0xf0)>>4)];
  push @res, $len>1 ? $cb64[(($in[1]&0xf)<<2)|(($in[2]&0xc0)>>6)] : ord('=');
  push @res, $len>2 ? $cb64[$in[2]&0x3f] : ord('=');
  return @res;
}

sub encode {
  my @in = unpack "C*", $_[0];

  my @out;
  while (scalar(@in)) {
	my @block = (0, 0, 0);
	my $length = 0;
	while (scalar(@in) && $length < 3) {
	  $block[$length++] = shift(@in);
	}
	push @out, encodeBlock($length, @block);
  }
  return pack "C*", @out;
}
