from parallels.plesk.source.helm3 import messages
from parallels.core.actions.base.legacy_action \
	import LegacyAction
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.actions.hosting_settings.convert.dns \
	import DNS as ActionConvertDNSPlesk
from parallels.plesk.source.helm3.actions.content.mail.copy_content import CopyMailContentFromHelm3ToPlesk
from parallels.plesk.source.helm3.actions.replace_db_server_ip \
	import ReplaceDbServerIp
from parallels.plesk.source.helm3.actions.content.web.copy_windows_content \
	import CopyWindowsWebContent
from parallels.plesk.source.plesk.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.plesk.source.helm3.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.plesk.source.helm3.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		workflow.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description=messages.ACTION_FETCH_DATA_FROM_SOURCE,
				function=lambda ctx: ctx.migrator._fetch_data(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		workflow.get_shared_action('fetch-source').insert_action(
			'replace-db-server-ip',
			ReplaceDbServerIp()
		)

		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionConvertDNSPlesk()
		)
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-files', CopyWindowsWebContent()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)
		workflow.replace_shared_action('copy-mail-content', CopyMailContentFromHelm3ToPlesk())
