import logging
from parallels.core import MigrationError
from parallels.core.actions.base.common_action import CommonAction
from parallels.ppa import messages

logger = logging.getLogger(__name__)


class CheckMainNodeLicense(CommonAction):
	def get_description(self):
		return messages.CHECK_PPA_MAIN_NODE_LICENSE

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_TO_CHECK_PPA_MAIN_NODE_LICENSE

	def filter_action(self, global_context):
		"""Check whether we should run this action or not.

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:rtype: bool
		"""
		return not global_context.options.skip_license_checks

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		if global_context.conn.target.poa_api().get_ppa_license_status() != "licensed":
			raise MigrationError(messages.PPA_MAIN_NODE_LICENSE_MISSING_OR_INVALID)
		logger.info(messages.MAIN_NODE_LICENSE_IS_OK)