from parallels.ppa import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties


class RemoveMaillists(SubscriptionBackupAction):
	"""Remove maillist definitions from backup.
	
	PPA doesn't support Mailman yet. Restoring maillists from backup causes
	issue which says that mail list service isn't available."""

	def get_description(self):
		return messages.ACTION_REMOVE_MAILLISTS_FROM_BACKUP

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_REMOVE_MAILLISTS_FOR_SUBSCRIPTION_S % subscription.name

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		subscription_backup.remove_maillists()
