import argparse
from parallels.core.cli.common_cli import Command, CommandTypes
from parallels.core.cli.extension import CLIExtensionBase
from parallels.ppa import messages


class CLIExtension(CLIExtensionBase):
	"""Command line migrator interface extension for target PPA panel"""

	def get_additional_commands(self, common_options):
		"""
		:type common_options: parallels.core.cli.migration_cli.CommonMigrationOptions
		:rtype: list[parallels.core.cli.common_cli.Command]
		"""
		remove_webspace_id_opts = argparse.ArgumentParser(add_help=False)
		remove_webspace_id_opts.add_argument(
			'--webspace-id', action='store',
			help=messages.HELP_WEBSPACE_ID_TO_REMOVE
		)

		return [
			Command(
				'remove-webspace', CommandTypes.MICRO,
				messages.COMMAND_REMOVE_WEBSPACE,
				lambda runner: runner.run_entry_point('remove-webspace'),
				common_options.global_options_list + [remove_webspace_id_opts, common_options.services_checks]
			)
		]