# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package PreMigrationChecks;

use strict;
use warnings;

use Dumper;
use DomainDumper;
use MySQLServer;
use PreMigration;

# put here all checks that could be performed independently from agent
sub checkOverall {
  unless (-e "/usr/bin/getapplversion") {
    print "Can't locate the PPCPL on this host.\n";
    exit (1);
  }
 
  PreMigration::assert(Dumper::getLocalNamedStatus() != 1, 'NAMED_NOT_RUNNING');
  my @duplicatedLogins = Dumper::getDuplicatedLogins();
  PreMigration::assert(scalar(@duplicatedLogins) > 0, 'DUPLICATED_SITE_LOGIN_NAMES',
      {'duplicateList' => PreMigration::formatList(@duplicatedLogins)}
  );
}

sub checkClient {
  my ($domain) = @_;

  my %context = ('client' => $domain, 'domain' => $domain, 'user' => DomainDumper::getSiteId($domain));

  PreMigration::assert(clientHasAdminDbUser($domain), 'DB_USER_ADMIN', {%context});
  PreMigration::assert(scalar(@{DomainDumper::getCronJobs($domain)}) > 0, 'CRON_JOBS', {%context});
  PreMigration::assert(scalar(DomainDumper::getPowerToolsAvailability($domain)) > 0, 'POWER_TOOLS_AVAILABLE', {%context});
  PreMigration::assert(scalar(keys %{DomainDumper::getMaillists($domain)}) > 0, 'MAILING_LISTS', {%context});
}

sub clientHasAdminDbUser {
  my ($domainName) = @_;

  my @clientDatabases = DomainDumper::getDatabaseNames($domainName);
  if (scalar(@clientDatabases)) {
    my @dbUsers = MySQLServer::getDatabaseUsers($clientDatabases[0]);
    return scalar(grep { $_ eq 'admin' } @dbUsers);
  }

  return 0;
}

1;
