from parallels.core.actions.content.web.copy_windows_content_base import CopyWindowsWebContentBase
from parallels.core.utils.paths import web_paths
from parallels.core.utils.paths.copy_web_content import CopyWebContentItem


class CopyWindowsWebContent(CopyWindowsWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		"""Make a list of source server directories to be transferred.

		Return a list of (source directory -> destination directory) mappings.

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:rtype: list[parallels.core.utils.paths.copy_web_content.CopyWebContentItem]
		"""
		sysuser = subscription.raw_dump.get_phosting_sysuser_name()
		if sysuser is None:
			# no physical hosting - no content to copy
			return []

		# Log files are not copied from H-Sphere.
		# The problem to include them is that they are placed in a separate directory
		# (\hslogfiles), all logs for all domains of all users.
		# It takes to determine IIS svc id to correctly get their location, but we don't execute commands
		# on source H-Sphere Windows nodes.

		tocopy = [
			# copy all stuff of H-Sphere Windows system user into webspace root on PPA service node
			# stuff includes:
			# directory of main domain, including virtual directories in it
			# directories of addon domains, including virtual directories in them
			# virtual directories that are placed outside of their respective domains
			# anything else (copy it just to preserve it)
			CopyWebContentItem(
				source_path=web_paths.VirtualHostsPath(sysuser + '/'),
				target_path=web_paths.WebspaceRoot(subscription.converted_dump),
				exclude=[],
				skip_if_source_not_exists=False
			)
		]

		return tocopy
