from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.plesk.workflow import WorkflowExtension as SourcePleskWorkflowExtension
from parallels.ppa.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		SourcePleskWorkflowExtension().extend_workflow(workflow)

		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)

		workflow.get_path('transfer-accounts').remove_actions([
			'check-migration-list'
		])

		workflow.get_shared_action('post-migration-prepare').remove_actions([
			'check-migration-list'
		])

		workflow.get_path('check').remove_actions([
			'check-migration-list'
		])