from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.actions.utils.multithreading_properties import MultithreadingProperties


class CopyMailContent(SubscriptionAction):
	def get_description(self):
		return "Copy mail messages"

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return (
			u"Failed to copy mail content of subscription. "
			u"Most probably that happens because of a network-related issue. Please check "
			u"network connections between source and target servers, then re-copy"
			u"mail content with the help of 'copy-mail-content' command"
		)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def filter_subscription(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return True

	def get_multithreading_properties(self):
		return MultithreadingProperties(can_use_threads=True)

	def run(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		safe = global_context.safe

		issues = []
		global_context.migrator._copy_mail_content_single_subscription(
			global_context.migrator_server, subscription, issues
		)
		for issue in issues:
			safe.add_issue_subscription(subscription.name, issue)