from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class SetDNSTimingsNotSupported(CommonAction):
	def get_description(self):
		return "Check if source panel supports setting DNS timings"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed to check if source panel supports setting DNS timings"

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		raise MigrationError(
			u"Setting low DNS timings is not supported by this type of migration. "
			u"Set them manually in the configurations of DNS zones, "
			u"or just wait for about two TTL intervals when migrating."
		)