
// Show popup dialog with confirmation to revert DNS forwarding.
// Arguments:
// - subscriptions - list of subscription names.
// - onSuccess - function that will be called once DNS revert of these subscriptions is scheduled.
function showRevertDnsPopup(subscriptions, onSuccess) {
    Jsw.messageBox.show({
        'type': Jsw.messageBox.TYPE_YESNO,
        'subtype': 'delete',
        'text': MESSAGE_POPUP_REVERT_DNS_DESCRIPTION,
        'onYesClick': function () {
            new Ajax.Request(URL_REVERT_DNS_SUBSCRIPTIONS, {
                parameters: {
                    subscriptions: Object.toJSON(subscriptions),
                    onSuccess: function() {
                        if (onSuccess) {
                            onSuccess();
                        }
                    }
                }
            });
        },
        'buttonTitles': {
            'yes': MESSAGE_POPUP_REVERT_DNS_BUTTON_YES,
            'no': MESSAGE_POPUP_REVERT_DNS_BUTTON_NO
        }
    });
}
