Jsw.onReady(function() {
    var continueButton = $('pre-checks-continue');
    var refreshButton = $('pre-checks-refresh');
    var closeButton = $('pre-checks-close');
    var discardButton = $('pre-checks-discard');

    function disableButtons(mainButton)
    {
        [continueButton, refreshButton, closeButton, discardButton].each(function(button) {
            button.disabled = true;
            button.up().addClassName('disabled');
        });
        mainButton.update(
            '<span class="wait">' + migratorLocale.lmsg('waitButtonTitle') + '</span>'
        );
    }

    continueButton.observe('click', function() {
        disableButtons(continueButton);
        new Ajax.Request(URL_START_MIGRATION + '/task/' + TASK_ID, {
            onSuccess: function (response) {
                Jsw.redirect(URL_MIGRATION_STATUS);
            }
        });
    });

    refreshButton.observe('click', function() {
        disableButtons(refreshButton);
        new Ajax.Request(URL_REFRESH_PRE_MIGRATION_CHECKS + '/task/' + TASK_ID, {
            onSuccess: function (response) {
                var data = response.responseText.evalJSON();
                showPreChecksPopup(data.task, false);
            }
        });
    });

    closeButton.observe('click', function() {
        disableButtons(closeButton);
        Jsw.redirect(URL_MIGRATION_STATUS);
    });

    discardButton.observe('click', function() {
        disableButtons(discardButton);
        new Ajax.Request(URL_DISCARD_PRE_MIGRATION_CHECKS + '/task/' + TASK_ID, {
            onSuccess: function (response) {
                Jsw.redirect(URL_MIGRATION_STATUS);
            }
        });
    });

    Jsw.Tooltip.init(continueButton, {text: migratorLocale.lmsg('preMigrationResultsButtonContinueHint')});
    Jsw.Tooltip.init(refreshButton, {text: migratorLocale.lmsg('preMigrationResultsButtonRefreshHint')});
    Jsw.Tooltip.init(closeButton, {text: migratorLocale.lmsg('preMigrationResultsButtonCloseHint')});
    Jsw.Tooltip.init(discardButton, {text: migratorLocale.lmsg('preMigrationResultsButtonDiscardHint')});

    function showAffectedObjectsPopup(title, description, objectNames) {
        var content = '<div>';
        content += description;
        content += '<ul>';
        objectNames.each(function(object) {
            content += '<li>' + object + '</li>';
        });
        content += '</ul>';
        content += '</div>';

        var popup = new Jsw.Popup({
            title: title,
            content: content,
            buttons: [
                {
                    id: 'affected-objects-close-button',
                    title: migratorLocale.lmsg('preMigrationResultsAffectedObjectButtonClose'),
                    handler: function (event, popup) {
                        popup.hide();
                    }
                }
            ],
            popupCls: 'popup-panel popup-panel-centered'
        });

        popup.show();
    }

    function displayAffectedObjects() {

    }

    $$('.affected-objects').each(function(element) {
        var issueNum = element.select('.issue-num').first().textContent;
        var affectedObjects = AFFECTED_OBJECTS[issueNum];
        if (affectedObjects.length > 0) {
            element.show();

            var sameTypeObjects = true;
            var firstObjectType = affectedObjects[0].object_type;
            var affectedObjectNames = [];
            affectedObjects.each(function(affectedObject) {
                if (affectedObject.object_type != firstObjectType) {
                    sameTypeObjects = false;
                }
                affectedObjectNames.push(affectedObject.name);
            });

            var title = '';
            var description = '';

            if (sameTypeObjects) {
                if (firstObjectType == 'subscription') {
                    title = migratorLocale.lmsg('preMigrationResultsTitleAffectedSubscriptions');
                    description = migratorLocale.lmsg('preMigrationResultsDescriptionAffectedSubscriptions');
                } else if (firstObjectType == 'mssql-server') {
                    title = migratorLocale.lmsg('preMigrationResultsTitleAffectedMssqlServers');
                    description = migratorLocale.lmsg('preMigrationResultsDescriptionAffectedMssqlServers');
                } else {
                    title = migratorLocale.lmsg('preMigrationResultsTitleAffectedObjects');
                    description = migratorLocale.lmsg('preMigrationResultsDescriptionAffectedObjects');
                }
            } else {
                title = migratorLocale.lmsg('preMigrationResultsTitleAffectedObjects');
                description = migratorLocale.lmsg('preMigrationResultsDescriptionAffectedObjects');
            }


            if (affectedObjects.length > MAX_AFFECTED_OBJECTS_INLINE) {
                var link = new Element('a').update(title + ' (' + affectedObjects.length + ')');
                link.observe('click', function() {
                    showAffectedObjectsPopup(title, description, affectedObjectNames);
                });
                element.update(link);
            } else {
                var html = '';
                html += '<div>' + description + '</div>';
                html += '<ul>';
                affectedObjectNames.each(function(name) {
                    html += '<li>' + name + '</li>';
                });
                html += '</ul>';
                element.update(html);
            }
        }
    });
});