// Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.

// Control to reassign migrated subscriptions to different client or reseller

// main function to initialize reassign control
function createReassignControl(id, data, value, lookupLocale)
{
    // create lookup field
    var reassignLookup = new Jsw.LookUpExtended({
        id: id + '-value',
        name: id + '[reassignTo]',
        renderTo: id + '-reassign-container',
        data: data,
        value: value,
        locale: lookupLocale
    });

    // handle switching of radio button: enable or disable lookup control
    var radioReassign = $(id + '-reassign');
    var radioDoNotChange = $(id + '-do-not-change');

    function setLookupEnabled() {
        if (radioReassign.checked) {
            reassignLookup.enable();
        } else {
            reassignLookup.disable();
        }
    }
    radioReassign.observe('change', setLookupEnabled);
    radioDoNotChange.observe('change', setLookupEnabled);

    setLookupEnabled();
}