from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction


class CopyContentAfterTransfer(CommonAction):
    def get_description(self):
        return messages.ACTION_COPY_CONTENT_AFTER_TRANSFER_DESCRIPTION

    def filter_action(self, global_context):
        """Check whether we should run this action or not. By default True - action should be executed.

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: bool
        """
        return global_context.options.resync_content

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_COPY_CONTENT_AFTER_TRANSFER_FAILURE

    def is_critical(self):
        """If action is critical or not

        :rtype: bool
        """
        return False

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        global_context.migrator.action_runner.run(global_context.migrator.workflow.get_shared_action('copy-content'))