from parallels.core import messages
import logging
from parallels.core.migrator_config import is_hosting_analyser_enabled

from parallels.plesk.hosting_analyser.hosting_analyser import HostingAnalyser
from parallels.core.actions.base.common_action import CommonAction

logger = logging.getLogger(__name__)


class AnalyseHosting(CommonAction):
    def get_description(self):
        return messages.ANALYSING_HOSTING_OS_RESOURCE_USAGE_AND

    def get_failure_message(self, global_context):
        return messages.FAILED_ANALYSE_MIGRATION_NODES

    def is_critical(self):
        """If action is critical or not

        If action is critical and it failed, migration tool won't run the next operations.

        :rtype: bool
        """
        return False

    def filter_action(self, global_context):
        """Check whether we should run this action or not. By default True - action should be executed.

        Arguments:
        - global_context - registry with different objects that reused among different actions

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: bool
        """
        return is_hosting_analyser_enabled(global_context.config)

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        analyser = HostingAnalyser(global_context.migrator_server)
        if analyser.is_nodes_type_supported(global_context.conn):
            analyser.analyse(global_context.conn, global_context.ssh_key_pool)
