from parallels.core import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
    import LoggingProperties
from parallels.core.migrator_config import MailContent
from parallels.core.reports.model.issue import Issue


class EmailEmptyPassword(SubscriptionBackupAction):
    def get_description(self):
        return messages.CHECK_EMPTY_PASSWORDS_MAILBOXES

    def get_failure_message(self, global_context, subscription):
        return messages.FAILED_CHECK_FOR_EMPTY_PASSWORDS_MAILBOXES % subscription.name

    def is_critical(self):
        """If action is critical or not

        If action is critical and it failed for a subscription, migration tool
        won't run the next operations for the subscription.

        :rtype: bool
        """
        return False

    def get_logging_properties(self):
        return LoggingProperties(info_log=False)

    def _run_subscription_backup(
        self, global_context, subscription, subscription_backup
    ):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        if (
            subscription.mail_source_server is None or 
            subscription.mail_source_server.mail_settings.mode == MailContent.NONE
        ):
            return
        
        for mailbox in subscription_backup.iter_mailboxes():
            if (mailbox.password is None or mailbox.password == '') and mailbox.enabled:
                subscription.add_report_issue(
                    global_context.pre_check_report,
                    'mailuser-with-empty-password', Issue.SEVERITY_WARNING,
                    messages.CONTENT_CAN_NOT_MIGRATED_FOR_S % mailbox.full_name,
                    messages.SET_PASSWORD_FOR_S_MAILUSER_SOURCE % mailbox.full_name
                )
