from parallels.core import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
    import LoggingProperties


class RemoveSubscriptionToPlanRelation(SubscriptionBackupAction):
    """Remove subscription to plan relation from backup dumps before restoring hosting settings

    We control subscription to plan relation when creating subscription on target system, not when restoring
    hosting settings. We need to remove subscription to plan relation from backup
    because otherwise relation may be overwritten when restoring hosting settings.
    Also consider:
    - Service template on target system may have different GUID than it has source system.
    - Another service template may be assigned in migration list.
    So we can't simply use service template from backup dump, we should either remove or update them in the dump.
    """

    def get_description(self):
        return messages.REMOVE_RELATION_PLANS_AND_SUBSCRIPTIONS_FROM

    def get_failure_message(self, global_context, subscription):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        return messages.FAILED_REMOVE_RELATION_PLANS_AND_SUBSCRIPTION % subscription.name

    def get_logging_properties(self):
        return LoggingProperties(info_log=False)

    def _run_subscription_backup(
        self, global_context, subscription, subscription_backup
    ):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        subscription_backup.remove_plans_reference()
