from parallels.core import messages


class Source(object):
    """This is a class to interact with source and get various common information about it
    """

    def __init__(self, source_id, config, migrator_server=None):
        """Constructor of Source object.

        :param source_id: str
        :param config: parallels.core.migrator_config.SourceConfig
        :param migrator_server: parallels.core.connections.migrator_server.MigratorServer
        """
        self.node_id = source_id
        self.node_settings = config
        self._migrator_server = migrator_server

    @property
    def id(self):
        """Alias for source_id

        :rtype: str
        """
        return self.source_id

    @property
    def source_id(self):
        """Identity of this source

        :rtype: str
        """
        return self.node_id

    @property
    def config(self):
        """Return source config

        :rtype: parallels.core.migrator_config.SourceConfig
        """
        return self.node_settings

    def description(self):
        """Return brief description which should help end customer
        to identify source and which should be used in all messages

        :rtype: str | unicode
        """
        return messages.SOURCE_DESCRIPTION % self.node_id

    def settings(self):
        """Alias for config

        :rtype: parallels.core.migrator_config.SourceConfig
        """
        return self.node_settings

    def __repr__(self):
        return 'Source(%r)' % self.node_id

    def __hash__(self):
        """Implemented for using objects as dictionary keys,
        for the purpose of grouping"""
        return hash(self.node_id)

    def __eq__(self, another):
        """Implement for using objects as dictionary keys,
        for the purpose of grouping"""
        return isinstance(another, Source) and self.node_id == another.node_id
