from parallels.core.dump.entity.description import Description


class Reseller(object):
    def __init__(
        self, node, login, password, plan_id, limits, permissions, contact, subscriptions, clients, personal_info,
        auxiliary_user_roles, auxiliary_users, is_enabled, external_id=None, creation_date=None
    ):
        self._node = node
        self.login = login
        self.password = password
        self.plan_id = plan_id
        self.limits = limits
        self.permissions = permissions
        self.contact = contact
        self.subscriptions = subscriptions
        self.clients = clients
        self.personal_info = personal_info
        self.auxiliary_user_roles = auxiliary_user_roles
        self.auxiliary_users = auxiliary_users
        self.is_enabled = is_enabled
        self.external_id = external_id
        self._creation_date = creation_date

    @property
    def creation_date(self):
        """Date when the reseller was initially created on the source server.

        Format is "YYYY-MM-DD", for example "2015-11-16" for 16 of November 2015

        :rtype: str | unicode
        """
        return self._creation_date

    @property
    def descriptions(self):
        """Descriptions owned by reseller

        :rtype: list[parallels.core.dump.entity.description.Description]
        """
        return [
            Description(description_node)
            for description_node in self._node.findall('preferences/descriptions/description')
        ]
