from parallels.core.utils.entity import Entity


class SubdomainModel(object):
    def get_list(self, filter_name=None):
        """Retrieve list of subdomains in target panel

        :type filter_name: list[str] | None
        :rtype: list[parallels.core.hosting_repository.subdomain.SubdomainEntity]
        """
        raise NotImplementedError()

    def get_by_name(self, name):
        """Retrieve subdomain with given name from target panel

        :type name: str
        :rtype: parallels.core.hosting_repository.subdomain.SubdomainEntity | None
        """
        subdomains = self.get_list(filter_name=[name])
        return subdomains.pop() if len(subdomains) > 0 else None

    def create_from_dump(self, subdomain_dump, domain_name, subscription_name):
        """Create subdomain in target panel

        :type subdomain_dump: parallels.core.dump.data_model.Subdomain
        :type domain_name: str
        :type subscription_name: str
        """
        raise NotImplementedError()

    def set_forwarding(self, subdomain_name, forwarding_url, is_frame_forwarding):
        """Enable forwarding on subdomain with given name in target panel

        :type subdomain_name: str
        :type forwarding_url: str
        :type is_frame_forwarding: bool
        """
        raise NotImplementedError()

    def set_physical_hosting(self, subdomain_name, document_root, is_enable_ssl):
        """Enable physical hosting on subdomain with given name in target panel

        :type subdomain_name: str
        :type document_root: str
        :type is_enable_ssl: bool
        """
        raise NotImplementedError()

    def is_exists(self, subdomain_name, guid=None):
        """Check if subdomain with given name or guid exists in target panel

        :type subdomain_name: str
        :type guid: str
        :rtype: bool
        """
        raise NotImplementedError()

    def update_security(self, subscription_name):
        """Actualize security metadata for subdomains of given subscription in target panel

        :type subscription_name: str
        """
        raise NotImplementedError


class SubdomainEntity(Entity):
    def __init__(self, subdomain_id, name, subscription_name):
        self._subdomain_id = subdomain_id
        self._name = name
        self._subscription_name = subscription_name

    @property
    def subdomain_id(self):
        return self._subdomain_id

    @property
    def name(self):
        return self._name

    @property
    def subscription_name(self):
        return self._subscription_name
