from parallels.core import messages

from parallels.core.utils.common.logging import create_safe_logger
from parallels.core.utils.common import cached

logger = create_safe_logger(__name__)


class AgentPool(object):

    @staticmethod
    @cached
    def get_instance():
        """Return pool of transfer agents

        :rtype: WindowsAgentPool
        """
        raise NotImplementedError()

    def __init__(self):
        self._agents = dict()

    def get(self, server_config, proxy_to=None, allow_autodeploy=True):
        key = self._key(server_config, proxy_to)
        if key not in self._agents:
            self._agents[key] = self._create_agent(server_config, proxy_to, allow_autodeploy)
        return self._agents[key]

    def close_all(self):
        for (ip, proxy_to), agent in self._agents.iteritems():
            if proxy_to is None:
                logger.debug(messages.SHUTDOWN_WINDOWS_AGENT_AT_S, ip)
                agent.shutdown()

    @staticmethod
    def _key(server_config, proxy_to):
        return server_config.server_id, proxy_to

    def _create_agent(self, server_config, proxy_to, allow_autodeploy):
        raise NotImplementedError()
