from parallels.core.utils.common.threading_utils import synchronized


class LocalTempFilename(object):
    """Thread-safe way to get name for a local temporary file"""

    def __init__(self):
        self._filenames = {}

    @synchronized
    def get(self, prefix):
        if prefix not in self._filenames:
            self._filenames[prefix] = 0
        self._filenames[prefix] += 1
        return "%s.%s" % (prefix, self._filenames[prefix])
