from parallels.core.utils.entity import Entity


class HostingDescriptionConfig(Entity):
    def __init__(self, source_id, path, file_format, validation_mode=None):
        """
        :type source_id: basestring
        :type path: basestring
        :type file_format: basestring
        """
        self._source_id = source_id
        self._path = path
        self._file_format = file_format
        self._validation_mode = validation_mode

    @property
    def source_id(self):
        """Source ID - section name in migrator's configuration file

        :rtype: basestring
        """
        return self._source_id

    @property
    def path(self):
        """Path to the hosting description file

        :rtype: basestring
        """
        return self._path

    @property
    def file_format(self):
        """File format of the hosting description file: JSON or YAML (see FORMAT_* constants)

        :rtype: basestring
        """
        return self._file_format

    @property
    def validation_mode(self):
        """Validation mode for that hosting description file
        See parallels.plesk.hosting_description.validate.mode.ValidationMode for details

        :rtype: basestring
        """
        return self._validation_mode
