from parallels.plesk.hosting_description.model import HostingDescriptionModel
from parallels.plesk.hosting_description.validate.attributes_validator import (
    HostingDescriptionAttributesValidator
)
from parallels.plesk.hosting_description.validate.files_validator import HostingDescriptionFilesValidator
from parallels.plesk.hosting_description.validate.schema_reader import (
    create_hosting_description_validator
)


class HostingDescriptionValidator(object):
    @staticmethod
    def validate(hosting_description_data, database_servers=None, content_source_server=None):
        """Perform all validations we have - structure, attributes, files

        Return list of errors found. If no errors were found - returns empty list

        :rtype: list[unicode]
        """
        model = HostingDescriptionModel(None, hosting_description_data)

        validator = create_hosting_description_validator()
        errors = validator.validate(hosting_description_data)

        attributes_validator = HostingDescriptionAttributesValidator()
        errors += attributes_validator.validate_model(model, database_servers)

        files_validator = HostingDescriptionFilesValidator()
        errors += files_validator.validate_model(model, content_source_server)

        return errors
