from parallels.core.hosting_repository.base import BaseModel


class PleskBaseModel(BaseModel):
    def __init__(self, plesk_server):
        """Intitiate model for given Plesk

        :type plesk_server: parallels.core.connections.plesk_server.PleskServer
        """
        super(PleskBaseModel, self).__init__()
        self._plesk_server = plesk_server

    @property
    def plesk_server(self):
        """Plesk server

        :rtype: parallels.core.connections.plesk_server.PleskServer
        """
        return self._plesk_server

    @property
    def plesk_cli_runner(self):
        """Runner for Plesk command line utilities

        :rtype: parallels.core.utils.plesk_cli_runner.PleskCLIRunnerBase
        """
        return self._plesk_server.cli_runner()
