from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class BackupEncryptDecryptCli(BaseCli):
    def __init__(self, runner, file_path):
        super(BackupEncryptDecryptCli, self).__init__(runner)
        self._file_path = file_path

    @property
    def name(self):
        return 'backup_encrypt'

    @property
    def is_private(self):
        return True

    def _get_args(self):
        return [
            '--decrypt-by-plesk',
            '-single-file', self._file_path
        ]
