from parallels.plesk.source.confixx import messages
from parallels.plesk.source.legacy.pmm_agent import UnixPmmMigrationAgent


class ConfixxPmmMigrationAgent(UnixPmmMigrationAgent):
    def __init__(self, global_context, server, migrator_dump_dir, settings):
        super(ConfixxPmmMigrationAgent, self).__init__(global_context, server, migrator_dump_dir, settings)

    def get_confixx_config_path(self):
        self.logger.info(messages.LOG_GET_CONFIXX_CONFIG_PATH)

        with self._source_server.runner() as runner:
            path = runner.sh(
                ur'cd {path}; {perl} ConfixxConfigPath.pl',
                {
                    'perl': self._perl_bin,
                    'path':    self.agent_dir
                }
            ).strip()
            self.logger.debug("Confixx config path = '%s'", path)
            return path
