from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.base.entry_point_action import EntryPointAction
from parallels.core.actions.content.database.copy_database_content import CopyDatabaseContent
from parallels.core.actions.content.web.copy_unix_content_base import CopyUnixWebContent
from parallels.core.utils.backup_adapter import SubscriptionBackup
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.custom.actions.content.database.restore_db_dumps import RestoreDBDumps
from parallels.plesk.source.custom.actions.content.mail.copy_mail_messages import CopyMailMessages
from parallels.plesk.source.custom.actions.content.mail.copy_mail_messages_local import \
    CustomPanelCopyUnixMailContentLocal
from parallels.plesk.source.custom.actions.content.web.fix_unix_permissions import CustomUnixFixPermissions
from parallels.plesk.source.custom.actions.content.web.copy_unix_content_local import CustomPanelCopyUnixWebContentLocal
from parallels.plesk.source.custom.actions.content.web.copy_windows_content import CustomPanelCopyWindowsWebContent
from parallels.plesk.source.custom.actions.content.web.copy_windows_content_local import (
    CustomPanelCopyWindowsWebContentLocal
)
from parallels.plesk.source.custom.actions.dump.create_converted_dump_from_raw_dump import (
    CustomPanelCreateConvertedDumpFromRawDump
)
from parallels.plesk.actions.dump.create_dump_from_hosting_description import CreateDumpFromHostingDescription
from parallels.plesk.source.custom.actions.dump.validate_hosting_description import ValidateHostingDescriptionFiles


class WorkflowExtension(WorkflowExtensionBase):
    def extend_workflow(self, workflow):
        """Extend shared hosting workflow with source-panel specific actions

        :type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
        """
        workflow.get_shared_action('fetch-source').insert_action(
            'validate-hosting-description-files', ValidateHostingDescriptionFiles()
        )
        workflow.get_shared_action('fetch-source').insert_action(
            'create-dump-from-hosting-description', CreateDumpFromHostingDescription()
        )

        workflow.get_path('generate-migration-list').remove_action('analyse-hosting')

        workflow.replace_shared_action('copy-db-content', CompoundAction())
        workflow.get_shared_action('copy-db-content').insert_action(
            'copy-db-from-servers', CopyDatabaseContent()
        )
        workflow.get_shared_action('copy-db-content').insert_action(
            'restore-db-dumps', RestoreDBDumps()
        )
        workflow.replace_shared_action('copy-mail-content', CompoundAction())
        workflow.get_shared_action('copy-mail-content').insert_action(
            'copy-local-mail-files', CustomPanelCopyUnixMailContentLocal()
        )
        workflow.get_shared_action('copy-mail-content').insert_action(
            'copy-mail-messages', CopyMailMessages()
        )
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-unix-files', CopyUnixWebContent()
        )
        workflow.get_shared_action('copy-web-files').insert_action(
            'fix-unix-permissions', CustomUnixFixPermissions()
        )
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-windows-files', CustomPanelCopyWindowsWebContent()
        )
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-windows-files-local', CustomPanelCopyWindowsWebContentLocal()
        )
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-unix-files-local', CustomPanelCopyUnixWebContentLocal()
        )

        # no need to check infrastructure in case of migration w/o source server access,
        # so just replace corresponding action with empty action
        workflow.replace_shared_action(
            'check-infrastructure', CompoundAction()
        )

        workflow.get_shared_action('convert-hosting').replace(
            'create-converted-backup',
            CustomPanelCreateConvertedDumpFromRawDump(SubscriptionBackup())
        )

        workflow.add_entry_point('validate', EntryPointAction())
        workflow.get_path('validate').insert_action(
            'validate-hosting-descriptions', ValidateHostingDescriptionFiles()
        )
