from parallels.core.migrated_subscription import MigratedSubscription


class ExpandMigratedSubscription(MigratedSubscription):
    # ====================== Subscription dumps =============================

    @property
    def mail_server_raw_dump(self):
        """Return full raw mail dump of the server

         Returns an object parallels.core.dump.PleskBackupSource*
         """
        if self.mail_source_server_id == self.model.source:
            # if mail source and subscription source is the same, return raw subscription backup
            return self.server_raw_dump
        return self._migrator.get_any_server_raw_dump(self.mail_source_server_id)

    @property
    def mail_server_converted_dump(self):
        """Return full raw mail converted of the server

         Returns an object parallels.core.dump.PleskBackupSource*
         """
        return self._migrator.load_converted_dump(self.mail_source_server_id)

    # ====================== Server objects ===================================

    @property
    def mail_source_server_id(self):
        return self._migrator.get_mail_server_id(self.model.source)
