# coding=utf-8
from parallels.core.utils.message_utils import single_line_message, multi_line_message, load_overrides

LOG_EXCEPTION = single_line_message("""
    Exception:
""")
LOG_REMOVE_EXISTING_BACKUP_FILE = single_line_message("""
    Remove previous existing backup file.
""")
CANNOT_GET_INFO_FROM_HELM = single_line_message("""
    Can't get info from Helm, error is '%s'; migration was stopped.
""")
CHECKING_IF_THERE_IS_ENOUGH_DISK_SPACE = single_line_message("""
    Checking if there is enough disk space on Plesk
""")
REPORT_DB_SERVERS_CONNECTIONS = single_line_message("""
    Connections between source and the destination database servers
""")
CANNOT_GET_HELM_WEB_NODE_IP = single_line_message("""
    Can't get Helm server's IP with web content for domain '{domain_name}', try to get FTP IP
""")
FETCH_HELM_SERVERS_INFO = single_line_message("""
    Fetch Helm servers information.
""")
REPORT_CONNECTIONS_WEB_NODES = single_line_message("""
    Connections between source and the destination web servers
""")
GET_DISK_USAGE_ON_WINDOWS_SERVER = single_line_message("""
    Calculating disk space usage on the source windows servers
""")
SKIP_LOADING_CACHED_HELM_DATA_FILES = single_line_message("""
    Data files for Helm already exist, skip loading
""")
REPORT_CONNECTIONS_MAIL_NODES = single_line_message("""
    Connections between source and the destination mail servers
""")
FAILED_TO_CHECK_CONNECTIONS_WEB_NODES = single_line_message("""
    Failed to check connections between source and the destination web servers
""")
FAILED_TO_CHECK_CONNECTIONS_DB_NODES = single_line_message("""
    Failed to check connections between source and the destination database servers
""")
CANNOT_GET_IP_ADDRESSES_FOR_SUBSCRIPTION = single_line_message("""
    Can't get IP addresses for subscription '%s'.
""")
CANNOT_GET_IP_ADDRESSES_FOR_SUBSCRIPTION_SERVICE_IPS_COMMAND = single_line_message("""
    Can't get IP addresses for subscription '%s'. Get service ips command return {%s} exit code.
""")
CANNOT_DETECT_IF_SUBSCRIPTION_IS_FAKE = single_line_message("""
    Can't detect if subscription '%s' fake or not.
""")
CANNOT_GET_DISK_USAGE_FOR_SUBSCRIPTION = single_line_message("""
    Can't get diskspace usage for subscription '%s'.
""")
CANNOT_DETECT_SOURCE_VHOST_DIR = single_line_message("""
    Can't detect source vhost dir for server with ip '%s'.
""")
CANNOT_FIND_SOURCE_SERVER_BY_ID = single_line_message("""
    Cannot find source server with ID '%s'.
""")
CANNOT_FIND_SOURCE_SERVER_BY_IP = single_line_message("""
    Cannot find source server with IP '%s'.
""")
RSYNC_FAILED_COPY_FILES = multi_line_message("""
    Rsync failed to copy files from the source (%s) to the target server (%s): %s
    This could happen because of a network connection issue.
    Retry copying the files with the help of the "copy-content" command.
""")
NO_VDIRS_FOR_SITE = single_line_message("""
    There is no virtual directories XML for site, virtual directories restoration is skipped for it
""")
CHANGE_FTP_USER_LOGINS = single_line_message("""
    Change FTP user logins so they conform to target panel's rules
""")
FAILED_TO_CHANGE_FTP_USER_LOGINS = single_line_message("""
    Failed to change FTP user logins so they conform to target panel's rules. FTP users may be restored incorrectly
""")
LOG_CHECK_CONNECTION_REQUIREMENTS = single_line_message("""
    Check connection requirements
""")
LOG_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Check disk space requirements
""")
REPORT_TARGET_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Disk space requirements
""")
CAN_NOT_GET_HELM_NODE_IP = single_line_message("""
    Can't get Helm server's IP with {content_type} content for domain '{domain_name}'.
    Migrator will skip copy {content_type} content for this domain.
    Most probably that you didn't describe server with {content_type} content with IP {node_ip}
    for this domain in config.ini. Resolve it to copy {content_type} content for this domain
""")
DOMAIN_HAS_NO_CONTENT_OF_THAT_TYPE = single_line_message("""
    Domain {domain_name} hasn't {content_type} content.
""")
ACTION_FETCH_DATA_FROM_SOURCE_DESCRIPTION = single_line_message("""
    Fetch data from source Helm
""")
ACTION_FETCH_DATA_FROM_SOURCE_FAILED = single_line_message("""
    Fetch data from source Helm
""")
CLI_CHECK_HELM_NODES = single_line_message("""
    Check connections to Helm servers involved into migration
""")
CHECK_HELM_NODES_ACTION_DESCRIPTION = single_line_message("""
    Check connections to Helm servers involved into migration
""")
CHECK_HELM_NODES_ACTION_FAILURE = single_line_message("""
    Failed to check connections to Helm servers involved into migration
""")
CANNOT_GET_INFO_ABOUT_SERVERS = single_line_message("""
    Can't get information about servers in Helm 3 cluster
""")
FAILED_TO_CONNECT_TO_HELM3_SERVER = single_line_message("""
    Failed to connect to '{server_name}' Helm server by '{server_ip}'
""")
SUCCESS_CONNECTED_TO_HELM3_SERVER = single_line_message("""
    Successfully connected to '{server_name}' Helm server by '{server_ip}'
""")
LOG_CHECK_CONNECTIONS_TO_SERVERS_LIST = single_line_message("""
    Check connections to {count} Helm server(s): {servers}
""")
LOG_CHECK_CONNECTIONS_TO_SERVER = single_line_message("""
    Check connection to '{server_name}' Helm server by '{server_ip}' ({num} out of {count})
""")
ACTION_FETCH_SHALLOW_DUMP_DESCRIPTION = single_line_message("""
    Fetch basic information about resellers, clients and domains data from source servers
""")
ACTION_FETCH_SHALLOW_DUMP_FAILURE = single_line_message("""
    Failed to fetch basic information about resellers, clients and domains data from source servers
""")

# Load language and UI type overrides. That must be the last line of root messages file.
load_overrides(__name__, locals())
