from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.base.entry_point_action import EntryPointAction
from parallels.core.actions.content.web.copy_windows_content_base import CopyWindowsWebContent
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.helm3.actions.check_helm_nodes import CheckHelmNodes
from parallels.plesk.source.helm3.actions.content.mail.copy_content import CopyMailContentFromHelm3ToPlesk
from parallels.plesk.source.helm3.actions.fetch_data import FetchData
from parallels.plesk.source.helm3.actions.fetch_shallow_dump import FetchShallowDumpAction
from parallels.plesk.source.plesk.actions.content.web.reset_permissions import ResetPermissions
from parallels.plesk.source.helm3.actions.hosting_settings.transfer_virtual_directories \
    import TransferVirtualDirectories
from parallels.plesk.source.helm3.actions.hosting_settings.transfer_mime_types import TransferMIMETypes


class WorkflowExtension(WorkflowExtensionBase):
    def extend_workflow(self, workflow):
        """Extend shared hosting workflow with source-panel specific actions

        :type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
        """
        workflow.replace_shared_action('fetch-source-shallow', CompoundAction())
        workflow.get_shared_action('fetch-source-shallow').insert_action(
            'fetch-shallow-backup', FetchShallowDumpAction()
        )
        workflow.get_shared_action('fetch-source').insert_action(
            'fetch-data', FetchData()
        )
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-files', CopyWindowsWebContent()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'reset-permissions', ResetPermissions()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'transfer-virtual-directories', TransferVirtualDirectories()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'transfer-mime-types', TransferMIMETypes()
        )
        workflow.replace_shared_action('copy-mail-content', CopyMailContentFromHelm3ToPlesk())

        workflow.get_path('check').insert_action(
            'check-helm-nodes', CheckHelmNodes(), before='check-remote-mssql'
        )

        workflow.add_entry_point('check-helm-nodes', EntryPointAction())
        workflow.get_path('check-helm-nodes').insert_action(
            'check-helm-nodes', CheckHelmNodes()
        )
        workflow.get_path('check-helm-nodes').insert_action(
            'cleanup',
            workflow.get_shared_action('cleanup')
        )
        workflow.get_path('check-helm-nodes').register_overall_shutdown('cleanup')
