# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package LegacyPanel::PreMigrationMessage;

use strict;
use warnings;

sub new($%) {
  my ($className, %parameters) = @_;
  my $self = {
    'object' => undef,
    'carrier' => undef,
    'message' => '',
    'resolution' => '',
  };
  bless $self, $className;
  $self->_init(%parameters);
  return $self;
}

=pod 

Fields:

object - scalar, name of the object this message is about. Nullable. If set to 'undef' - last node from 
'carrier' filed will be taken.

carrier - tree element carrying the object. Nullable.

message - message itself (issue description).

resolution - resolution message. Nullable.

=cut

sub _init($%) {
  my ($self, %params) = @_;
  $self->setObject($params{'object'}) if exists($params{'object'});
  $self->setCarrier($params{'carrier'}) if exists($params{'carrier'});
  $self->setMessage($params{'message'}) if exists($params{'message'});
  $self->setResolution($params{'resolution'}) if exists($params{'resolution'});
}

sub setObject($$) {
  my ($self, $object) = @_;
  $self->{'object'} = $object;
}

sub setCarrier($$) {
  my ($self, $carrier) = @_;
  $self->{'carrier'} = $carrier;
}

sub setMessage($$) {
  my ($self, $message) = @_;
  $self->{'message'} = $message;
}

sub setResolution($$) {
  my ($self, $resolution) = @_;
  $self->{'resolution'} = $resolution;
}

sub toString(@) {
  my ($self, $objectToTextSub) = @_;
  unless (defined($objectToTextSub) and ref($objectToTextSub) eq 'CODE') {
    $objectToTextSub = sub { 
      my ($object, $carrier) = @_;
      if ($object->can('toString')) {
        return ($object->toString(), []);
      } else {
        return ("$object", []);
      }
    };
  }

  my ($object, $carrier) = $objectToTextSub->($self->{'object'}, $self->{'carrier'});

  my $message = '';
  $message .= "Object: " . $object . "\n";
  if (defined($carrier) and ref($carrier) eq 'ARRAY' and scalar(@{$carrier})) {
    $message .= "Placement: " . join(' / ', @{$carrier}) . "\n";
  }
  $message .= "Message: " . $self->{'message'} . "\n";
  if ($self->{'resolution'} ne '') {
    $message .= "Solution: " . $self->{'resolution'} . "\n";
  }
  return $message;
}

1;
