from parallels.core.actions.base.common_action import CommonAction
from parallels.core.utils.common_constants import PLESK_EXTENSION_BACKUP_TYPE_SERVER, PLESK_EXTENSION_HOOK_SERVER, \
    PLESK_EXTENSION_HOOK_SERVER_POST_BACKUP
from parallels.plesk.source.plesk import messages
from parallels.plesk.source.plesk.actions.utils import get_target_plesk_server, iter_extensions, \
    is_extensions_supported
from parallels.plesk.source.plesk.actions.deploy.extensions.utils import DeployMessages, ExtensionDeployer


class DeployExtensionsServer(CommonAction):
    def get_description(self):
        return messages.ACTION_DEPLOY_EXTENSIONS_SERVER

    def get_failure_message(self, global_context):
        return messages.ACTION_DEPLOY_EXTENSIONS_SERVER_FAILED

    def is_critical(self):
        return False

    def filter_action(self, global_context):
        return is_extensions_supported(global_context)

    def run(self, global_context):
        """Transfer server level data of Plesk extensions

        :type global_context: parallels.plesk.source.plesk.global_context.PleskGlobalMigrationContext
        """
        target_plesk_server = get_target_plesk_server(global_context)
        for extension, source_plesk_server in iter_extensions(
            global_context,
            filter_hook=[PLESK_EXTENSION_HOOK_SERVER]
        ):
            deploy_messages = DeployMessages(
                backup_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_BACKUP,
                backup_failed_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_BACKUP_FAILED,
                backup_failed_solution_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_BACKUP_FAILED_SOLUTION,
                copy_content_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_COPY_CONTENT,
                copy_content_failed_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_COPY_CONTENT_FAILED,
                copy_content_failed_solution_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_COPY_CONTENT_FAILED_SOLUTION,
                clear_backup_temp_data_failed_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_CLEAR_BACKUP_TEMP_DATA_FAILED,
                restore_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_RESTORE,
                restore_failed_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_RESTORE_FAILED,
                restore_failed_solution_message=messages.ACTION_DEPLOY_EXTENSIONS_SERVER_RESTORE_FAILED_SOLUTION
            )
            for error_message, solution in ExtensionDeployer(
                global_context,
                global_context.cache_state_controllers.common,
                extension,
                PLESK_EXTENSION_BACKUP_TYPE_SERVER,
            ).deploy(
                deploy_messages,
                source_plesk_server,
                target_plesk_server,
                extension.is_hook_available(PLESK_EXTENSION_HOOK_SERVER_POST_BACKUP),
            ):
                global_context.safe.fail_general(error_message, solution)
