# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package MySQLAgent::Backend::Base;

use strict;

sub new {
  my $self = {};
  bless($self, shift);
  $self->_init(@_);
  return $self;
}

sub _init {
  my ($self, %params) = @_;

  $self->{database} = $params{database};
  $self->{user} = $params{user};
  $self->{password} = $params{password};
  $self->{host} = $params{host} if defined $params{host};
  $self->{port} = $params{port} if defined $params{port};
  $self->{socket} = $params{socket} if defined $params{socket};
}

#
# Subclass must override this function.
# Return value: 0 - error, <> 0 - success.
# errstr must be set on error.
#
sub connect {
  die "Pure virtual function call";
}

sub disconnect {
  die "Pure virtual function call";
}

# Execute specified query and return result as array of hashes
sub queryArrayOfHashes {
  die "Pure virtual function call";
}

sub errstr {
  my ($self) = @_;

  return $self->{errstr};
}

sub errcode {
  my ($self) = @_;

  return $self->{errcode};
}

sub _set_errstr {
  my ($self, $errstr, $errcode) = @_;
  $self->{errstr} = $errstr;
  $self->{errcode} = $errcode;
}

1;
