# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package MySQLAgent::Backend::Utils;

use strict;

sub doesSupportCharacterSets {
  my ($conn) = @_;

  return $conn->queryArrayOfHashes("SHOW VARIABLES LIKE \"character_set_results\"") > 0
}

sub getCharacterSetsSupportSql {
  return "SET character_set_results = 'utf8', character_set_server = 'utf8', character_set_connection = 'utf8', character_set_client = 'utf8'";
}

sub getNamesCharacterSetsSupportSql {
  return "SET NAMES utf8";
}

sub getVersion {
  my $version = `mysql --version`;
  if ($version and $version =~ /Distrib (\d+\.\d+)\./){
    return $1;
  }
}

sub getVersionArray {
  my $version = `mysql --version`;
  if ($version and $version =~ /Distrib (\d+)\.(\d+)(?:\.(\d+))?/){
    return ($1, $2, $3);
  }
}

1;